/**
  Copyright (c) 2010 Freescale Semiconductor
  
  \file       AnimationCtrl.h
  \brief      This file contains the definition structures for controling movie clips
  \author     Freescale Semiconductor
  \author     Automotive Systems Solutions Engineering
  \author     IM, b06623
  \version	  2.0
  \revision	  $Revision: 21 $
  \date  	  $Date: 2010-09-09 19:26:09 -0500 (Thu, 09 Sep 2010) $  
  
  * History:  27/March/2009 - Initial Version

* Copyright (c) 2010, Freescale, Inc.  All rights reserved.
*
*
* No part of this document must be reproduced in any form - including copied,
* transcribed, printed or by any electronic means - without specific written
* permission from Freescale Semiconductor.
*
   
*/

#ifndef	_ANIMATIONCTRL_H_
#define	_ANIMATIONCTRL_H_


#include "..\HAL\DCU_drv.h"

/********************* Movie Clip Manager data definition *********************/

typedef void (*mc_function_t)(uint32_t CurrentFrame);
typedef void (*mc_functionExt_t)(void);
#define MCMANAGER_NOOWNER	(0xFFFFu)


typedef struct
{
    mc_function_t			mcFunction;
    mc_functionExt_t 	 	Dispose;
    mc_functionExt_t 	 	Refresh;
     uint8_t		priority;
     uint16_t 		usedLayers;
    uint32_t			frameLatch;
    uint8_t				enabled;
    uint8_t				autoDispose;
    uint8_t				run;
    uint8_t				kill;    
}mc_properties_t;


/********************* Movie Clip Manager cfg parameters *********************/

#define MCMANAGER_MAXCLIPSCTX0	(8)
#define MCMANAGER_MAXCLIPSCTX1	(8)



/********************* Movie Clip Manager API *********************/

void MCManager_SetContext(uint8_t ctx);
void MCManager_Init(void);
void MCManager_Main(uint32_t CurrentFrame);
void MCManager_Refresh(void);
void MCManager_AutoRefresh(void);


extern mc_properties_t** MCManager_MClips;
extern uint16_t* MCManager_LayerOwner;

#endif
